﻿// Example submitted by Bob Swart

using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using System.Data;
using TicTacToe;


namespace TicTacToe
{
	/// <summary>
	/// Summary description for WinForm1.
	/// </summary>
	public class WinForm1 : System.Windows.Forms.Form
	{
		/// <summary>
		/// Required designer variable.
		/// </summary>
		private System.ComponentModel.Container components = null;
		private System.Windows.Forms.MainMenu mainMenu1;
		private System.Windows.Forms.MenuItem menuItem1;
		private System.Windows.Forms.MenuItem menuItem2;
		private System.Windows.Forms.MenuItem MenuComputerStarts;
		private System.Windows.Forms.MenuItem MenuUserStarts;
		private System.Windows.Forms.MenuItem menuItem5;
		private System.Windows.Forms.MenuItem menuItem6;
		private System.Windows.Forms.Button btn8;
		private System.Windows.Forms.Button btn3;
		private System.Windows.Forms.Button btn4;
		private System.Windows.Forms.Button btn1;
		private System.Windows.Forms.Button btn5;
		private System.Windows.Forms.Button btn9;
		private System.Windows.Forms.Button btn6;
		private System.Windows.Forms.Button btn7;
		private System.Windows.Forms.Button btn2;
		private ITicTacToeservice TTT = null;
		private int Game = 0;
		private int TTTIsWinnerGame = 0;

		public WinForm1()
		{
			//
			// Required for Windows Form Designer support
			//
			InitializeComponent();

			//
			// TODO: Add any constructor code after InitializeComponent call
			//
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose (bool disposing)
		{
			if (disposing)
			{
				if (components != null)
				{
					components.Dispose();
				}
			}
			base.Dispose(disposing);
		}

		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			System.Resources.ResourceManager resources = new System.Resources.ResourceManager(typeof(WinForm1));
			this.mainMenu1 = new System.Windows.Forms.MainMenu();
			this.menuItem1 = new System.Windows.Forms.MenuItem();
			this.menuItem2 = new System.Windows.Forms.MenuItem();
			this.MenuComputerStarts = new System.Windows.Forms.MenuItem();
			this.MenuUserStarts = new System.Windows.Forms.MenuItem();
			this.menuItem5 = new System.Windows.Forms.MenuItem();
			this.menuItem6 = new System.Windows.Forms.MenuItem();
			this.btn8 = new System.Windows.Forms.Button();
			this.btn3 = new System.Windows.Forms.Button();
			this.btn4 = new System.Windows.Forms.Button();
			this.btn1 = new System.Windows.Forms.Button();
			this.btn5 = new System.Windows.Forms.Button();
			this.btn9 = new System.Windows.Forms.Button();
			this.btn6 = new System.Windows.Forms.Button();
			this.btn7 = new System.Windows.Forms.Button();
			this.btn2 = new System.Windows.Forms.Button();
			this.SuspendLayout();
			// 
			// mainMenu1
			// 
			this.mainMenu1.MenuItems.AddRange(new System.Windows.Forms.MenuItem[] {
						this.menuItem1,
						this.menuItem5});
			// 
			// menuItem1
			// 
			this.menuItem1.Index = 0;
			this.menuItem1.MenuItems.AddRange(new System.Windows.Forms.MenuItem[] {
						this.menuItem2});
			this.menuItem1.Text = "Game";
			// 
			// menuItem2
			// 
			this.menuItem2.Index = 0;
			this.menuItem2.MenuItems.AddRange(new System.Windows.Forms.MenuItem[] {
						this.MenuComputerStarts,
						this.MenuUserStarts});
			this.menuItem2.Text = "New";
			// 
			// MenuComputerStarts
			// 
			this.MenuComputerStarts.Index = 0;
			this.MenuComputerStarts.Text = "Computer Starts";
			this.MenuComputerStarts.Click += new System.EventHandler(this.menuComputerStarts_Click);
			// 
			// MenuUserStarts
			// 
			this.MenuUserStarts.Index = 1;
			this.MenuUserStarts.Text = "User Starts";
			this.MenuUserStarts.Click += new System.EventHandler(this.menuUserStarts_Click);
			// 
			// menuItem5
			// 
			this.menuItem5.Index = 1;
			this.menuItem5.MenuItems.AddRange(new System.Windows.Forms.MenuItem[] {
						this.menuItem6});
			this.menuItem5.Text = "Help";
			// 
			// menuItem6
			// 
			this.menuItem6.Index = 0;
			this.menuItem6.Text = "About...";
			this.menuItem6.Click += new System.EventHandler(this.menuItem6_Click);
			// 
			// btn8
			// 
			this.btn8.Font = new System.Drawing.Font("Microsoft Sans Serif", 32F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
			this.btn8.Location = new System.Drawing.Point(8, 16);
			this.btn8.Name = "btn8";
			this.btn8.Size = new System.Drawing.Size(88, 72);
			this.btn8.TabIndex = 8;
			this.btn8.Tag = "8";
			this.btn8.Click += new System.EventHandler(this.button_Click);
			// 
			// btn3
			// 
			this.btn3.Font = new System.Drawing.Font("Microsoft Sans Serif", 32F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
			this.btn3.Location = new System.Drawing.Point(104, 16);
			this.btn3.Name = "btn3";
			this.btn3.Size = new System.Drawing.Size(88, 72);
			this.btn3.TabIndex = 7;
			this.btn3.Tag = "3";
			this.btn3.Click += new System.EventHandler(this.button_Click);
			// 
			// btn4
			// 
			this.btn4.Font = new System.Drawing.Font("Microsoft Sans Serif", 32F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
			this.btn4.Location = new System.Drawing.Point(200, 16);
			this.btn4.Name = "btn4";
			this.btn4.Size = new System.Drawing.Size(88, 72);
			this.btn4.TabIndex = 6;
			this.btn4.Tag = "4";
			this.btn4.Click += new System.EventHandler(this.button_Click);
			// 
			// btn1
			// 
			this.btn1.Font = new System.Drawing.Font("Microsoft Sans Serif", 32F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
			this.btn1.Location = new System.Drawing.Point(8, 96);
			this.btn1.Name = "btn1";
			this.btn1.Size = new System.Drawing.Size(88, 72);
			this.btn1.TabIndex = 5;
			this.btn1.Tag = "1";
			this.btn1.Click += new System.EventHandler(this.button_Click);
			// 
			// btn5
			// 
			this.btn5.Font = new System.Drawing.Font("Microsoft Sans Serif", 32F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
			this.btn5.Location = new System.Drawing.Point(104, 96);
			this.btn5.Name = "btn5";
			this.btn5.Size = new System.Drawing.Size(88, 72);
			this.btn5.TabIndex = 0;
			this.btn5.Tag = "5";
			this.btn5.Click += new System.EventHandler(this.button_Click);
			// 
			// btn9
			// 
			this.btn9.Font = new System.Drawing.Font("Microsoft Sans Serif", 32F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
			this.btn9.Location = new System.Drawing.Point(200, 96);
			this.btn9.Name = "btn9";
			this.btn9.Size = new System.Drawing.Size(88, 72);
			this.btn9.TabIndex = 3;
			this.btn9.Tag = "9";
			this.btn9.Click += new System.EventHandler(this.button_Click);
			// 
			// btn6
			// 
			this.btn6.Font = new System.Drawing.Font("Microsoft Sans Serif", 32F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
			this.btn6.Location = new System.Drawing.Point(8, 176);
			this.btn6.Name = "btn6";
			this.btn6.Size = new System.Drawing.Size(88, 72);
			this.btn6.TabIndex = 2;
			this.btn6.Tag = "6";
			this.btn6.Click += new System.EventHandler(this.button_Click);
			// 
			// btn7
			// 
			this.btn7.Font = new System.Drawing.Font("Microsoft Sans Serif", 32F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
			this.btn7.Location = new System.Drawing.Point(104, 176);
			this.btn7.Name = "btn7";
			this.btn7.Size = new System.Drawing.Size(88, 72);
			this.btn7.TabIndex = 1;
			this.btn7.Tag = "7";
			this.btn7.Click += new System.EventHandler(this.button_Click);
			// 
			// btn2
			// 
			this.btn2.Font = new System.Drawing.Font("Microsoft Sans Serif", 32F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
			this.btn2.Location = new System.Drawing.Point(200, 176);
			this.btn2.Name = "btn2";
			this.btn2.Size = new System.Drawing.Size(88, 72);
			this.btn2.TabIndex = 0;
			this.btn2.Tag = "2";
			this.btn2.Click += new System.EventHandler(this.button_Click);
			// 
			// WinForm1
			// 
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.ClientSize = new System.Drawing.Size(296, 246);
			this.Controls.Add(this.btn2);
			this.Controls.Add(this.btn7);
			this.Controls.Add(this.btn6);
			this.Controls.Add(this.btn9);
			this.Controls.Add(this.btn5);
			this.Controls.Add(this.btn1);
			this.Controls.Add(this.btn4);
			this.Controls.Add(this.btn3);
			this.Controls.Add(this.btn8);
			this.Icon = ((System.Drawing.Icon)(resources.GetObject("$this.Icon")));
			this.MaximizeBox = false;
			this.MaximumSize = new System.Drawing.Size(304, 304);
			this.Menu = this.mainMenu1;
			this.MinimumSize = new System.Drawing.Size(304, 304);
			this.Name = "WinForm1";
			this.Text = "TicTacToe web service client";
			this.ResumeLayout(false);
		}
		#endregion

		/// <summary>
		/// The main entry point for the application.
		/// </summary>
		[STAThread]
		static void Main()
		{
			Application.Run(new WinForm1());
		}

		private void Init_TTT()
		{
			if (TTT == null)
			try
			{
				TTT = new ITicTacToeservice();
			}
			catch (Exception ex)
			{
				MessageBox.Show(ex.Message, "Error");
			}
		}

		private void Clear_Board()
		{
			btn1.Text = "";
			btn2.Text = "";
			btn3.Text = "";
			btn4.Text = "";
			btn5.Text = "";
			btn6.Text = "";
			btn7.Text = "";
			btn8.Text = "";
			btn9.Text = "";
			TTTIsWinnerGame = 0;
		}

		const int Human = 1;
		const int Computer = 2;

		private void ComputerMove()
		{
			int Move = TTT.NextMove(Game, Computer);
			TTT.MakeMove(Game, Computer, Move);
			switch (Move)
			{
				case 1: btn1.Text = "42"; break;
				case 2: btn2.Text = "42"; break;
				case 3: btn3.Text = "42"; break;
				case 4: btn4.Text = "42"; break;
				case 5: btn5.Text = "42"; break;
				case 6: btn6.Text = "42"; break;
				case 7: btn7.Text = "42"; break;
				case 8: btn8.Text = "42"; break;
				case 9: btn9.Text = "42"; break;
			}
			TTTIsWinnerGame = TTT.IsWinner(Game);
			if (TTTIsWinnerGame == Computer)
				MessageBox.Show("I have won this game!");
		}

		private void HumanMove(object NewMove)
		{
			int Move = Convert.ToInt32(NewMove);
			TTT.MakeMove(Game, Human, Move);
			TTTIsWinnerGame = TTT.IsWinner(Game);
			if (TTTIsWinnerGame == Human)
				MessageBox.Show("Congratulations: you have won!");
			else
				if (TTT.NextMove(Game, Computer) > 0)
					ComputerMove();
		}

		private void menuItem6_Click(object sender, System.EventArgs e)
		{
			MessageBox.Show("See http://www.drbob42.net/csharpbuilder", "Dr.Bob Says...");
		}

		private void button_Click(object sender, System.EventArgs e)
		{
			if (Game == 0) menuUserStarts_Click(sender, e);
			switch (TTTIsWinnerGame)
			{
				case Computer:
					MessageBox.Show("Computer has already won!"); break;
				case Human:
					MessageBox.Show("You have already won!"); break;
				default:
					if ((sender as Button).Text == "")
					{
						(sender as Button).Text = "X";
						Update();
						HumanMove((sender as Button).Tag);
					}; break;
			}
		}

		private void menuUserStarts_Click(object sender, System.EventArgs e)
		{
			// User Starts
			Init_TTT();
			Clear_Board();
			Game = TTT.NewGame();
			Text = "Game: " + Convert.ToString(Game);
		}
		
		private void menuComputerStarts_Click(object sender, System.EventArgs e)
		{
			// Computer Starts
			Init_TTT();
			Clear_Board();
			Game = TTT.NewGame();
			Text = "Game: " + Convert.ToString(Game);
			ComputerMove();
		}
	}
}
